<?php
// WRAPPING UP ALL VARIOUS E-MAIL DISPATCHES TRIGGERED BY VARIOUS ACTIONS



///////////////////////////////////////////
/// MAIL IMPORTED USERS ///////////////////
///////////////////////////////////////////

function pcma_mail_imported($imported_list) {
	if(pcma_is_active() && get_option('pcma_niu_enable')) {
		global $pc_users;
		
		$raw_txt = get_option('pcma_niu_txt');
		
		foreach($imported_list as $user_id => $arr_data) {
			if(isset($arr_data['email']) && !empty($arr_data['email'])) {

				$txt = pcma_apply_mail_templates(get_option('pcma_niu_template'), $raw_txt);
				$txt = pcma_replace_placeholders($user_id, $txt, $arr_data);
				$txt = str_replace('%PSW%', $arr_data['psw'], $txt);

				$title = pcma_replace_placeholders($user_id, get_option('pcma_niu_subj'), $arr_data);
				$mail_sent = pcma_send_mail($arr_data['username'], $arr_data['email'], $title, $txt);
			}
		}
	}
}
add_action('pc_imported_users', 'pcma_mail_imported');






///////////////////////////////////////////
/// ADMIN NOTIFIER - NEW USER /////////////
///////////////////////////////////////////

// send e-mail when new user registers
function pcma_admin_notifier_nu($user_id) {
	if(pcma_is_active() && get_option('pcma_nnu_enable')) {

		$txt = pcma_apply_mail_templates(get_option('pcma_nnu_template'), get_option('pcma_nnu_txt'));
		$txt = pcma_replace_placeholders($user_id, $txt);
		$title = pcma_replace_placeholders($user_id, get_option('pcma_nnu_subj'));
		
		$to_mail = (get_option('pcma_nnu_mail_multi')) ? get_option('pcma_nnu_mail_multi') : get_option('pcma_nnu_mail');
		$to_mail = explode(',', $to_mail);
        
		
		// get user data to set ReplyTo
		global $pc_users;
		$replyto_name  = $pc_users->get_user_field($user_id, 'username');
		$replyto_email = $pc_users->get_user_field($user_id, 'email');
		
        foreach($to_mail as $tm) {
		  $mail_sent = pcma_send_mail(get_bloginfo('name'), trim($tm), $title, $txt, false, false, $replyto_name, $replyto_email);
        }
        
        if(get_option('pcma_nnu_for_pc_admin')) {
            foreach(pcma_get_assoc_pc_admin_users($user_id) as $wp_user_email => $wp_user_name) {
                $mail_sent = pcma_send_mail($wp_user_name, $wp_user_email, $title, $txt, false, false, $replyto_name, $replyto_email);        
            }
        }
	}
}

function pcma_admin_notifier_trigger() {
    
    if(get_option('pcma_mv_enable') && get_option('pcma_nnu_behav') == 'mail_verified') {
        add_action('pcma_user_verified_email', 'pcma_admin_notifier_nu');
    } 
    else {
        add_action('pc_registered_user', 'pcma_admin_notifier_nu');
    }
}
add_action('init', 'pcma_admin_notifier_trigger', 10);







///////////////////////////////////////////
/// ADMIN NOTIFIER - SELF-DELETED USER ////
///////////////////////////////////////////

// send e-mail when new user registers
function pcma_admin_notifier_du($user_id) {
	if(pcma_is_active() && get_option('pcma_dun_enable')) {

		$txt = pcma_apply_mail_templates(get_option('pcma_dun_template'), get_option('pcma_dun_txt'));
		$txt = pcma_replace_placeholders($user_id, $txt);
		$title = pcma_replace_placeholders($user_id, get_option('pcma_dun_subj'));
		
		$to_mail = get_option('pcma_nnu_mail_multi');
		$mail_sent = pcma_send_mail(get_bloginfo('name'), $to_mail, $title, $txt);
        
        if(get_option('pcma_dun_for_pc_admin')) {
            foreach(pcma_get_assoc_pc_admin_users($user_id) as $wp_user_email => $wp_user_name) {
                $mail_sent = pcma_send_mail($wp_user_name, $wp_user_email, $title, $txt);        
            }
        }
	}
}
add_action('pc_pre_self_user_del', 'pcma_admin_notifier_du');







///////////////////////////////////////////
/// USER NOTIFIER - FOR ACTIVATED USERS ///
///////////////////////////////////////////

// send e-mail if admin enables them
function pcma_activ_user_notifier($user_id) {
	if(pcma_is_active() && get_option('pcma_nau_enable')) {

		global $pc_users;
		$u_data = $pc_users->get_user($user_id, array('to_get' => array('id', 'email', 'name', 'surname', 'username', 'tel', 'psw', 'categories')));
		
		if(!empty($u_data) && !empty($u_data['email'])) {
			$user_title = pcma_replace_placeholders($u_data['id'], get_option('pcma_nau_subj'), $u_data);

			$txt = pcma_apply_mail_templates(get_option('pcma_nau_template'), get_option('pcma_nau_txt'));
			$user_txt = pcma_replace_placeholders($u_data['id'], $txt, $u_data);
			
			// send
			$mail_sent = pcma_send_mail($u_data['username'], $u_data['email'], $user_title, $user_txt);	
		}
	}
}
add_action('pc_user_activated', 'pcma_activ_user_notifier', 50);








///////////////////////////////////////////////////
/// WELCOME MESSAGE ///////////////////////////////
///////////////////////////////////////////////////

// send mail on registation or
function pcma_registration_welcome_mess($user_id, $status) {
	if(pcma_is_active()) { 
		$switch = get_option('pcma_wm_receiver', 'active_users');
		
		if(get_option('pcma_wm_enable') && ($switch == 'any_user' || $status == 1)) {

			global $pc_users;
			$u_data = $pc_users->get_user($user_id, array('to_get' => array('id', 'email', 'name', 'surname', 'username', 'tel', 'psw', 'categories')));
			
			if(!empty($u_data) && !empty($u_data['email'])) {
				$user_title = pcma_replace_placeholders($u_data['id'], get_option('pcma_wm_subj'), $u_data);
				
				$txt = pcma_apply_mail_templates(get_option('pcma_wm_template'), get_option('pcma_wm_txt'));
				$user_txt = pcma_replace_placeholders($u_data['id'], $txt, $u_data);
				
				// send
				$mail_sent = pcma_send_mail($u_data['username'], $u_data['email'], $user_title, $user_txt);	
			}
		}
	}
}
add_action('pc_registered_user', 'pcma_registration_welcome_mess', 10, 2);



// send mail if WP user allowed it inserting via admin panel
function pcma_add_user_welcome_mess($user_id) {
	if(isset($_POST['pcma_au_send_welcome']) && $_POST['pcma_au_send_welcome']) {
		pcma_registration_welcome_mess($user_id, 1);	
	}
}
add_action('pc_user_added_by_admin', 'pcma_add_user_welcome_mess');








///////////////////////////////////////////////////
/// GOODBYE MESSAGE ///////////////////////////////
///////////////////////////////////////////////////

// send e-mail when user self-deletes itself
function pcma_self_del_user_mess($user_id) {
	if(pcma_is_active() && get_option('pcma_gm_enable')) {

		global $pc_users;
		$u_data = $pc_users->get_user($user_id, array('to_get' => array('id', 'email', 'name', 'surname', 'username', 'tel', 'psw', 'categories')));
		
		if(!empty($u_data) && !empty($u_data['email'])) {
			$user_title = pcma_replace_placeholders($u_data['id'], get_option('pcma_gm_subj'), $u_data);

			$txt = pcma_apply_mail_templates(get_option('pcma_gm_template'), get_option('pcma_gm_txt'));
			$user_txt = pcma_replace_placeholders($u_data['id'], $txt, $u_data);
			
			// send
			$mail_sent = pcma_send_mail($u_data['username'], $u_data['email'], $user_title, $user_txt);	
		}
	}
}
add_action('pc_pre_self_user_del', 'pcma_self_del_user_mess');

